<?php
/**
 * @package lightrr
 * @since lightrr 1.0
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="featured-img">
		<?php lightrr_data_over(true, true, true) ?>
		<a href="<?php esc_url( the_permalink() ); ?>" title="<?php printf( esc_html__( 'Permalink to %s', 'lightrr' ), the_title_attribute( 'echo=0' ) ); ?>" rel="bookmark"><?php lightrr_featured_thumb('lightrr_list_thumb'); ?></a>
		<?php if ( is_sticky() ) { echo '<div class="lightrr__sticky-label lightrr__icon-star-full">' . esc_html__('Sticky', 'lightrr') . '</div>'; } ?>
	</div>

	<div class="entry-content">
		<?php the_title( sprintf( '<h2 class="entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' ); ?>

		<div class="entry-meta meta-buttons">
			<a href="<?php echo esc_url( get_author_posts_url(get_the_author_meta( 'ID' )) ); ?>" class="meta-author hidden-xs"><?php the_author(); ?></a>
			<a href="<?php esc_url( the_permalink() ); ?>"><time class="meta-date" datetime="<?php esc_attr (the_time( 'c' ) ); ?>"><?php if ( cs_get_option('time_relative', true) ) { echo esc_html( human_time_diff(get_the_time('U'), current_time('timestamp')) ) . ' ' . __('ago', 'lightrr'); } else { the_time( get_option( 'date_format' ) ); } ?></time></a>
			<?php lightrr_comments_nb('meta-com'); ?>
		</div>
	</div>
</article> 