<?php

/**
 * @package lightrr
 * @since lightrr 1.0
 */
get_header();
?>

	<!-- ============================= Content Container -->
<div class="container-fluid lightrr__image-container">
		<?php if (have_posts()) : while (have_posts()) : the_post(); ?>

			<div class="lightrr__image-content">

				<div class="lightrr__attachment">
					<?php
					$attachments = array_values(get_children(array('post_parent' => $post->post_parent, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => 'ASC', 'orderby' => 'menu_order ID')));
					$next_attachment_url = wp_get_attachment_url(); ?>

					<a href="<?php echo esc_url( $next_attachment_url ); ?>" title="<?php echo esc_attr(get_the_title()); ?>" rel="attachment"><?php $attachment = wp_get_attachment_image_src( $post->ID, 'full' );
					echo '<img src="'. esc_url( $attachment[0] ) .'" alt="" />';?></a>

				<?php if (!empty($post->post_excerpt)): ?>
					<div class="entry-caption">
						<?php the_excerpt(); ?>
					</div>
				<?php endif; ?>
				</div><!-- .attachment -->

				<div class="lightrr__media-meta">
				<?php
					$metadata = wp_get_attachment_metadata();
					printf(' <time class="entry-date" datetime="%1$s">%2$s</time></span>'  . ' // <a href="%6$s" title="Return to %7$s" rel="gallery">%7$s</a>', esc_attr(get_the_date('c')), esc_html(get_the_date()), esc_url( wp_get_attachment_url() ), $metadata['width'], $metadata['height'], esc_url( get_permalink($post->post_parent) ), get_the_title($post->post_parent));?>
				</div><!-- .entry-meta -->

			</div>

		<?php endwhile; endif; wp_reset_postdata(); ?>
</div> <!--/container -->

<?php
get_footer();
?>