<?php
/**
 * Template tags for lightrr
 *
 * @package lightrr
 * @since lightrr 1.0
 */

/* Post Navigation
 =================================================================================================== */

if ( ! function_exists( 'lightrr_post_navigation' ) ) :
function lightrr_post_navigation() {
	?>

	<nav class="lightrr__post-navigation">
		<div class="prev-post-button">
			<span class="label-button">&lt; <?php esc_html_e('Prev Post', 'lightrr'); ?></span>
			<?php previous_post_link( '%link' ); ?>
			<?php if(!get_adjacent_post(false, '', true)) { ?>
				<a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
				<?php esc_html_e('Home: ', 'lightrr'); bloginfo( 'name' ); ?></a>
			<?php } ?>
		</div>

		<div class="next-post-button">
			<span class="label-button"><?php esc_html_e('Next Post', 'lightrr'); ?> &gt;</span>
			<?php next_post_link( '%link' ); ?>
			<?php if(!get_adjacent_post(false, '', false)) { ?>
				<a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php esc_html_e('Home: ', 'lightrr'); bloginfo( 'name' ); ?></a>
			<?php } ?>
		</div>
	</nav> <!--/navigation -->

	<?php
}
endif;

/* Post Thumbnail
 =================================================================================================== */

if ( ! function_exists( 'lightrr_featured_thumb' ) ) :
function lightrr_featured_thumb($thumb_size = "") {

	$imgdlt = get_template_directory_uri()."/img/def.png";

	if ( 'lightrr_list_thumb' == $thumb_size && 'fixed_layout' == cs_get_option('layout_style', 'masonry_layout') ) {
		$thumb_size = "lightrr_poster_l";
	}
	elseif ('lightrr_list_thumb' == $thumb_size){
		$thumb_size = "lightrr_main_feed";
	}

	if ( has_post_thumbnail() ) {
		echo the_post_thumbnail($thumb_size);
	}
	else{
		echo "<img class='lightrr__default-thumb' src='". esc_url( $imgdlt ) ."' alt='' />";
	}
}
endif;


/* Post Header
 =================================================================================================== */

if ( ! function_exists( 'lightrr_post_head' ) ) :
function lightrr_post_head() {
	global $post;

	$caption = isset(get_post(get_post_thumbnail_id())->post_excerpt) ? get_post(get_post_thumbnail_id())->post_excerpt : '';
	$post_image = !get_post_meta($post->ID, 'lightrr_meta_sidebar', true) && !is_page_template( 'page-full-width.php' ) ? get_the_post_thumbnail($post->ID, 'lightrr_single_post') : get_the_post_thumbnail($post->ID, 'large');
	$post_gallery = cs_get_option('set_theme_slider', true) && has_post_format('gallery') ? true : false;

	if ( has_post_thumbnail() || has_post_format(array( 'gallery', 'audio', 'video' )) ) { ?>

	<div class="lightrr__featured-media">
		<?php echo wp_kses($post_image, array('img' => array('width' => array(),'height' => array(),'src' => array(),'class' => array(),'alt' => array())))?>
		<?php lightrr_category_style('single'); ?>
		<?php if (!empty($caption)) { echo '<div class="lightrr__slide-caption">'.esc_html($caption).'</div>'; } ?>
		<div class="lightrr__chroma"></div>
	</div>

	<?php }

}
endif;

/* Share Buttons
 =================================================================================================== */

if ( ! function_exists( 'lightrr_share' ) ) :
function lightrr_share() {

	$link = get_permalink();
	$title = get_the_title();
	$attachment = wp_get_attachment_image_src( get_post_thumbnail_id(), 'large');
	$featured_img = isset($attachment[0]) ? $attachment[0] : '';

	$icons = array();
	$icons = array(

	'twitter' =>
		array(
			'url' => 'https://twitter.com/share?url='.esc_url($link).'&amp;text='.urlencode($title).'',
			'id' => cs_get_option('share_twitter', true)
		),
	'facebook' =>
		array(
			'url' => 'http://facebook.com/share.php?u='.esc_url($link).'',
			'id' => cs_get_option('share_facebook', true)
		),
	'google' =>
		array(
			'url' => 'https://plus.google.com/share?url='.esc_url($link).'',
			'id' => cs_get_option('share_google', true)
		),
	'linkedin' =>
		array(
			'url' => 'http://linkedin.com/shareArticle?mini=true&url='.esc_url($link).'',
			'id' => cs_get_option('share_linkedin', false)
		),
	'reddit' =>
		array(
			'url' => 'http://reddit.com/submit?url='.esc_url($link).'',
			'id' => cs_get_option('share_reddit', false)
		),
	'tumblr' =>
		array(
			'url' => 'http://tumblr.com/share/link?url='.esc_url($link).'&name='.esc_html($title).'',
			'id' => cs_get_option('share_tumblr', false)
		),
	'pinterest' =>
		array(
			'url' => 'http://pinterest.com/pin/create/button/?url='.esc_url($link).'&media='.esc_url($featured_img).'&description='.esc_html($title).'',
			'id' => cs_get_option('share_pinterest', false)
		),
	'vk' =>
		array(
			'url' => 'http://vk.com/share.php?url='.esc_url($link).'',
			'id' => cs_get_option('share_vk', false)
		),
	'envelop' =>
		array(
			'url' => 'mailto:?subject='.esc_html($title).'&body='.esc_url($link).'',
			'id' => cs_get_option('share_email', false)
		),

	);

	foreach($icons as $key => $item) {
		if (!empty($item['id'])) {
			echo '<a class="lightrr__icon-'.esc_attr( $key ).'" href="'.esc_url( $item['url'] ).'"><span class="lightrr__unset">Share</span></a>';
		}
	}

}
endif;


/* Author Social Links
 =================================================================================================== */

if ( ! function_exists( 'lightrr_author_icons' ) ) :
function lightrr_author_icons() {

	$user_id = get_the_author_meta('ID');
	$icons = array();
	$icons = array(
	'twitter' => get_user_meta ($user_id , 'twitter', true),
	'facebook' => get_user_meta ($user_id , 'facebook', true),
	'google-plus' => get_user_meta ($user_id , 'gplus', true),
	'instagram' => get_user_meta ($user_id , 'instagram', true),
	'vk' => get_user_meta ($user_id , 'vk', true),
	);

	foreach($icons as $key => $item) {
		if (!empty($item)) {
			echo '<a href="'.esc_url($item).'"><i class="lightrr__icon-'.esc_attr($key).'"><span class="lightrr_linknm">'.esc_html($key).'</span></i></a>';
		}
	}

}
endif;

/* Social Icons
 =================================================================================================== */

if ( ! function_exists( 'lightrr_icons' ) ) :
function lightrr_icons() {

	$icons = array();
	$icons = array(
	'twitter' => cs_get_option('twitter_id', false),
	'facebook' => cs_get_option('facebook_id', false),
	'google-plus' => cs_get_option('gplus_id', false),
	'instagram' => cs_get_option('instagram_id', false),
	'soundcloud' => cs_get_option('soundcloud_id', false),
	'pinterest' => cs_get_option('pinterest_id', false),
	'youtube' => cs_get_option('youtube_id', false),
	'vimeo' => cs_get_option('vimeo_id', false),
	'tumblr' => cs_get_option('tumblr_id', false),
	'twitch' => cs_get_option('twitch_id', false),
	'steam' => cs_get_option('steam_id', false),
	'linkedin' => cs_get_option('linkedin_id', false),
	'vk' => cs_get_option('vk_id', false),
	'rss' => cs_get_option('feed_id', false),
	);

	// foreach($icons as $key => $item) {
	// 	if (!empty($item)) {
	// 		echo '<a href="'.esc_url($item).'"><i class="lightrr__icon-'.esc_attr($key).'"><span class="lightrr_linknm">'.esc_html($key).'</span></i></a>';
	// 	}
	// }
	foreach($icons as $key => $item) {
		if (!empty($item)) {
			echo '<li><a target="_blank" href="'.esc_url($item).'">'.esc_html($key).'</a></li>';
		}
	}
}
endif;

/* Number of comments
 =================================================================================================== */

if (!function_exists('lightrr_comments_nb')):
	function lightrr_comments_nb($lightrr_comments_class, $label = '') {
		global $post;

		$lightrr_comments_number = get_comments_number('0', '1', '%');
		$lightrr_postlink = get_permalink();
		$lightrr_comments_label = '';

		if ('1' == $lightrr_comments_number && true == $label) {
			$lightrr_comments_label = esc_html__('Comment', 'lightrr');
		}
		elseif (true == $label) {
			$lightrr_comments_label = esc_html__('Comments', 'lightrr');
		}

		echo '<a href="' . esc_url( $lightrr_postlink ) . '#comments" class="lightrr__icon-bubble2 ' . esc_attr( $lightrr_comments_class ) . '">' . esc_html( $lightrr_comments_number ) . ' ' . esc_html( $lightrr_comments_label ) . ' </a>';
	}
endif;

/* Post Views
 =================================================================================================== */

function lightrr_getPostViews($postID) {
	$count_key = 'post_views_count';
	$count = get_post_meta($postID, $count_key, true);
	if ($count == '') {
		delete_post_meta($postID, $count_key);
		add_post_meta($postID, $count_key, '0');
		return "0";
	}
	return $count;
}

function lightrr_setPostViews($postID) {
	$count_key = 'post_views_count';
	$count = get_post_meta($postID, $count_key, true);
	if ($count == '') {
		$count = 0;
		delete_post_meta($postID, $count_key);
		add_post_meta($postID, $count_key, '0');
	} else {
		$count++;
		update_post_meta($postID, $count_key, sanitize_text_field($count));

	}
}

/* Overlay Data
 =================================================================================================== */

if (!function_exists('lightrr_data_over')):
function lightrr_data_over($get_cat, $get_score, $get_format, $score_width = '40') {
	global $post;

	$rtbase = 'scoreinit' == cs_get_option('st_score', 'scoreinit') ? '100' : '10';
	$is_scored = get_post_meta($post->ID, 'lightrr_meta_reviewon', true);
	$score_value = get_post_meta($post->ID, 'lightrr_meta_review_score', true);
	$result = '100' == $rtbase ? $score_value : $score_value*10;
	if ($get_cat && has_category() && !$is_scored) { lightrr_category_style('single'); }

?>
	<?php if ($get_score && !empty($score_value) && $is_scored ) { ?>
		<div class="lightrr__score lightrr__score-overlay"><div style="width:<?php echo esc_attr($result); ?>%;" class="lightrr__fill-score"></div><span class="lightrr__label-score"><?php echo esc_html__('Review', 'lightrr') ?></span><span class="lightrr__final"><?php echo esc_attr($score_value); ?></span></div>
	<?php } ?>
	<?php if ($get_format && has_post_format('gallery') && !$is_scored) { ?>
		<a href="<?php echo esc_url(get_permalink()); ?>"><span class="ub-overlay lightrr__icon-gallery lightrr__icon-camera"></span></a>
	<?php }  elseif (has_post_format('video') && !$is_scored) { ?>
		<a href="<?php echo esc_url(get_permalink()); ?>"><span class="ub-overlay lightrr__icon-video lightrr__icon-play3"></span></a>
	<?php } elseif (has_post_format('audio') && !$is_scored) { ?>
		<a href="<?php echo esc_url(get_permalink()); ?>"><span class="ub-overlay lightrr__icon-audio lightrr__icon-music"></span></a>
	<?php } ?>

<?php

}
endif;

/* Styled Category
 =================================================================================================== */

if ( ! function_exists( 'lightrr_category_style' ) ) :
function lightrr_category_style($catlimit = ''){
	global $post;
	$categories = get_the_category($post->ID);

	if ($categories) { ?>
		<span class="lightrr__color-cat color-cats">
		<?php foreach($categories as $category) {
			$cat_link = get_category_link( $category->cat_ID );
			$cat_nm = $category->cat_name;
			$cat_ids = $category->term_id;
			$term_meta = get_option( "term_$cat_ids" );
			$term_meta['textcolor'] = ( !empty( $term_meta['textcolor'] ) ) ? $term_meta['textcolor'] : "#fff";
			$term_meta['bgcolor']   = ( !empty( $term_meta['bgcolor'] ) ) ? $term_meta['bgcolor'] : "#666";
		?>
		<?php echo esc_html($cat_nm); ?>
		<?php if ( !cs_get_option('multi_cats_th', false) ) break; } ?>
		</span>
<?php
	}
}
endif;

/* Custom logo
 =================================================================================================== */

if ( ! function_exists( 'lightrr_custom_logo' ) ) :
function lightrr_custom_logo($location) {

	$blognm = get_bloginfo('name');

	if ('header' == $location) {
		$image_url = cs_get_option('logo_uploader');
	}
	else {
		$image_url = cs_get_option('logo_uploader_menu');
	}

	echo '<img src="' . esc_url( $image_url ) . '" alt="' . esc_attr( $blognm ) . '" />';
}
endif;

/* Template Page URL
 =================================================================================================== */

if (!function_exists('lightrr_template_page_url')) :
function lightrr_template_page_url($template_name){
	$pages = '';
	$pageurl = '';
	$args = array(
		'post_type' => 'page',
		'fields' => 'ids',
		'nopaging' => true,
		'meta_key' => '_wp_page_template',
		'meta_value' => $template_name
	);
	$pages = get_posts( $args );

	if(!empty($pages)) {
		$pageid = $pages[0];
		$pageurl = get_page_link($pageid);
	}
	return $pageurl;
}
endif;

/* Posts Navigation
 =================================================================================================== */

if (!function_exists('lightrr_content_nav')) :

function lightrr_content_nav() {
	global $wp_query, $post;

	if ($wp_query->max_num_pages < 2 && (is_home() || is_page_template('page-blog.php') || is_archive() || is_search())) return;

	$nav_style = cs_get_option('st_nav', 'prevnext');
	$page_number = (get_query_var('paged')) ? get_query_var('paged') : 1;

	$nav_class = 'lightrr__site-navigation';
	if ( !is_paged() && "loadmore" == $nav_style ) { $nav_class = 'lightrr__load-nav'; }
	if ( "numbered" == $nav_style ) { $nav_class = 'lightrr__numbered-nav'; }
?>

<nav id="nav-below" class="<?php echo esc_attr( $nav_class ); ?>">
<?php if ("numbered" !== $nav_style && $wp_query->max_num_pages > 1 && (is_home() || is_archive() || is_search() )) : ?>

		<?php if (get_next_posts_link() && "loadmore" !== $nav_style || is_paged()): ?>
			<div class="nav-previous"><?php next_posts_link(esc_html__('&lt; Older posts', 'lightrr')); ?></div>

		<?php else : ?>
			<div class="nav-load"><?php next_posts_link(esc_html__('Load More', 'lightrr')); ?></div>
		<?php endif; ?>

		<?php if (get_previous_posts_link() && "loadmore" !== $nav_style || is_paged()): ?>
			<div class="nav-next"><?php previous_posts_link(esc_html__('Newer posts &gt;', 'lightrr')); ?></div>
		<?php endif; ?>

<?php else : ?>

	<?php $big = 999999999;
	echo paginate_links(array(
		'base' => str_replace($big, '%#%', esc_url(get_pagenum_link($big))) ,
		'prev_next'          => false,
		'format' => '?paged=%#%',
		'type' => 'list',
		'prev_text' => '&laquo;',
		'next_text' => '&raquo;',
		'current' => max(1, get_query_var('paged')) ,
		'total' => $wp_query->max_num_pages
	)); ?>

<?php endif; ?>
</nav>

<?php }
endif; // lightrrcontent_nav

/* Custom class
 =================================================================================================== */

function lightrr_custom_class() {
	global $post;

	$output = "";
	$nosidebar = get_post_meta($post->ID, 'lightrr_meta_sidebar', true);

	if ( $nosidebar || is_page_template( 'page-fullwidth.php' ) ) {
		$output .= 'col-md-10 col-md-push-1';
	}

	if( !is_page() && !$nosidebar && !is_page_template( 'page-fullwidth.php' ) ) {
		$output .= 'col-md-8';
	}

	return $output;
}

/* Display Review Panel
 =================================================================================================== */

if (!function_exists('lightrr_scored_panel')) :
function lightrr_scored_panel() {
	global $post;
	$rtbase = 'scoreinit' == cs_get_option('st_score', 'scoreinit') ? '100' : '10';
	$score_value = get_post_meta($post->ID, 'lightrr_meta_review_score', true);
	$fresult = '100' == $rtbase ? $score_value : $score_value*10;
?>
<div class="lightrr__score-panel lightrr__wow-fade" itemscope itemtype="http://schema.org/Review">

	<div class="lightrr__review-info">
		<div class="lightrr__review-score">
			<div class="lightrr__score" itemprop="reviewRating" itemscope itemtype="http://schema.org/Rating">
				<span class="lightrr__snipphd" itemprop="ratingValue"><?php echo esc_html(get_post_meta($post->ID, 'lightrr_meta_review_score', true)); ?></span>
				<span class="lightrr__snipphd" itemprop="bestRating"><?php echo esc_html($rtbase); ?></span>
				<div style="width:<?php echo esc_attr($fresult); ?>%;" class="lightrr__fill-score"></div><span class="lightrr__final"><?php echo esc_attr(get_post_meta($post->ID, 'lightrr_meta_review_score', true)); ?></span>
			</div>
			<span class="lightrr__review-tag"><?php echo esc_html( get_post_meta($post->ID, 'lightrr_meta_review_title', true) ); ?></span>
		</div>

		<div class="lightrr__review-extract" itemprop="itemReviewed" itemscope itemtype="http://schema.org/Thing">
			<span class="lightrr__snipphd" itemprop="name"><?php the_title();?></span>
			<span class="lightrr__review-description" itemprop="description"><?php echo esc_html( get_post_meta($post->ID, 'lightrr_meta_review_summ', true) ); ?></span>
		</div>

	<div class="review-author" itemprop="author" itemscope itemtype="http://schema.org/Person">
			<span class="lightrr__snipphd" itemprop="name"><?php the_author();?></span>
		</div>
	</div>

	<div class="lightrr__review-criteria">
		<?php
			for ($i = 1; $i <= 4; $i++) {
				$score = get_post_meta( $post->ID, 'lightrr_meta_review_criterion_score_'.esc_attr($i), true );
				if( !empty($score) ) {
					$result = '100' == $rtbase ? $score : $score*10;
					$criteria = get_post_meta( $post->ID, 'lightrr_meta_review_criterion_'.esc_attr($i), true );
		?>
		<div class="progress">
			<div class="progress-bar progress-bar-info lightrr__unwidth" role="progressbar" aria-valuenow="<?php echo esc_attr($result); ?>" aria-valuemin="0" aria-valuemax="<?php echo esc_attr($rtbase); ?>" style="width:<?php echo esc_attr($result); ?>%">
				<span class="lightrr__base-cr"><?php echo esc_html($criteria); ?></span>
				<span class="lightrr__base-sc"><?php echo esc_html($score); ?></span>
			</div>
		</div>
		<?php } } ?>
	</div>

</div>

<?php }
endif;

/* Custom body class
 =================================================================================================== */
function lightrr_body_class( $mrgclass ) {

	global $post;
	$layout = cs_get_option('lightrr_sorter_ll');
	$layout = isset($layout['enabled']) ? $layout['enabled'] : array();
	$featured = array_key_exists('content-featured-area', $layout) ? true : false;

	if ( 'espanol' == cs_get_option('idioma', 'espanol') ) {
		$mrgclass[] = 'lightrr--es';
	}
	elseif ( 'ingles' == cs_get_option('idioma', 'espanol') ) {
		$mrgclass[] = 'lightrr--en';
	}

	return $mrgclass;
}
add_filter( 'body_class', 'lightrr_body_class' );
