<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access pages directly.
/**
 *
 * Text sanitize
 *
 * @since 1.0.0
 * @version 1.0.0
 *
 */
if( ! function_exists( 'cs_sanitize_text' ) ) {
  function cs_sanitize_text( $value, $field ) {
    return wp_strip_all_tags( $value );
  }
  add_filter( 'cs_sanitize_text', 'cs_sanitize_text', 10, 2 );
}

/**
 *
 * Textarea sanitize
 *
 * @since 1.0.0
 * @version 1.0.0
 *
 */
if( ! function_exists( 'cs_sanitize_textarea' ) ) {
  function cs_sanitize_textarea( $value ) {

    global $allowedposttags;
    return wp_kses( $value, $allowedposttags );

  }
  add_filter( 'cs_sanitize_textarea', 'cs_sanitize_textarea' );
}

add_action('admin_init','optionscheck_change_sanitize', 100);
function optionscheck_change_sanitize() {
  remove_filter( 'cs_sanitize_textarea', 'cs_sanitize_textarea' );
  add_filter( 'cs_sanitize_textarea', 'cs_sanitize_textarea_custom' );
}

function cs_sanitize_textarea_custom($value) {
  global $allowedposttags;
    $cs_custom_allowedtags["script"] = array(
      "type" => array(),
      "src" => array(),
      "class" => array(),
      "async" => array(), 
      "data-id" => array(),
      "data-format" => array(), 
    );
    $cs_custom_allowedtags["ins"] = array(
       "class" => array(),
       "style" => array(),
       "data-ad-client" => array(),
       "data-ad-slot" => array(),
       "data-ad-format" => array(),
    );

    $cs_custom_allowedtags["style"] = array(
    );

    $cs_custom_allowedtags = array_merge($cs_custom_allowedtags, $allowedposttags);
    $output = $value;
  return $output;
}

/**
 *
 * Checkbox sanitize
 * Do not touch, or think twice.
 *
 * @since 1.0.0
 * @version 1.0.0
 *
 */
if( ! function_exists( 'cs_sanitize_checkbox' ) ) {
  function cs_sanitize_checkbox( $value ) {

    if( ! empty( $value ) && $value == 1 ) {
      $value = true;
    }

    if( empty( $value ) ) {
      $value = false;
    }

    return $value;

  }
  add_filter( 'cs_sanitize_checkbox', 'cs_sanitize_checkbox' );
  add_filter( 'cs_sanitize_switcher', 'cs_sanitize_checkbox' );
}

/**
 *
 * Image select sanitize
 * Do not touch, or think twice.
 *
 *
 * @since 1.0.0
 * @version 1.0.0
 *
 */
if( ! function_exists( 'cs_sanitize_image_select' ) ) {
  function cs_sanitize_image_select( $value ) {

    if( isset( $value ) && is_array( $value ) ) {
      if( count( $value ) ) {
        $value = $value;
      } else {
        $value = $value[0];
      }
    } else if ( empty( $value ) ) {
      $value = '';
    }

    return $value;

  }
  add_filter( 'cs_sanitize_image_select', 'cs_sanitize_image_select' );
}

/**
 *
 * Group sanitize
 * Do not touch, or think twice.
 *
 * @since 1.0.0
 * @version 1.0.0
 *
 */
if( ! function_exists( 'cs_sanitize_group' ) ) {
  function cs_sanitize_group( $value ) {
    return ( empty( $value ) ) ? '' : $value;
  }
  add_filter( 'cs_sanitize_group', 'cs_sanitize_group' );
}

/**
 *
 * Title sanitize
 *
 * @since 1.0.0
 * @version 1.0.0
 *
 */
if( ! function_exists( 'cs_sanitize_title' ) ) {
  function cs_sanitize_title( $value ) {
    return sanitize_title( $value );
  }
  add_filter( 'cs_sanitize_title', 'cs_sanitize_title' );
}

/**
 *
 * Text clean
 *
 * @since 1.0.0
 * @version 1.0.0
 *
 */
if( ! function_exists( 'cs_sanitize_clean' ) ) {
  function cs_sanitize_clean( $value ) {
    return $value;
  }
  add_filter( 'cs_sanitize_clean', 'cs_sanitize_clean', 10, 2 );
}
