<?php
/**
 * @package lightrr
 * @since lightrr 1.0
 */


function lightrr_options_bg_dph($option, $selectors) {
	if (cs_get_option('set_bg', false)) {
		$output = $selectors . '{';
		
		if ($option['color']) {
			$output.= ' background-color: ' . $option['color'] . ';';
			if (!$option['image']) {
				$output.= ' background-image: none;';
			}
		}
		
		if (cs_get_option('bg_overlay', false)) {
			$overlaybg = 'url(' . get_template_directory_uri() . '/img/overlay_a.png) fixed,';
			$overlayauto = 'auto,';
		} else {
			$overlaybg = '';
			$overlayauto = '';
		}
		
		if ($option['image']) {
			$output.= ' background: ' . $overlaybg . 'url(' . esc_url($option['image']) . ') 50% 50% fixed no-repeat;';
			$output.= ' background-repeat: ' . esc_attr( $option['repeat'] ) . ';';
			$output.= ' background-position: ' . esc_attr( $option['position'] ) . ';';
			$output.= ' background-attachment: ' . esc_attr( $option['attachment'] ) . ';';
			$output.= ' background-size: ' . esc_attr( $option['size'] ) . ';';
			$output.= ' image-rendering:-webkit-optimize-contrast';
		}
		
		$output.= '}';
		$output.= "\n";
		return $output;
	} else {
		return null;
	}
}

function lightrr_options_custom_styles() {
	
	$output = '';
	$input = '';

	$main_color = cs_get_option('main_color', '#FFC000');
	$alt_color = cs_get_option('alt_color', '#FCD911');

	$output.= lightrr_options_bg_dph(cs_get_option('bg_opt') , 'body'); //Custom BG
	if ( 'dark_nav' == cs_get_option('header_style', 'light_nav') ) { //white icons
		$output.= ".container-head .#{$pre}__mini-icons i{color:#fff;}";
	}
	if ( 'style_2' == cs_get_option('menubtn_style', 'style_1') ) { //white icons
		$output.= "#lightrr__btnav span{width:27px;}";
	}
	if ( !cs_get_option('lightrr_color_over', true) ) { //disable overlay
		$output.= ".#{$pre}__chroma,.#{$pre}__featured-media .#{$pre}__chroma,.transform-fx:hover .#{$pre}__chroma{opacity:0;}";
	}

	$query = array(
		array('id' => 1, 'selector' => 'a,a:link,h3.#{$pre}__pre-title .pre-sub,#footer .sf-menu a:hover,#lightrr__list-feed .entry-title a:hover,#lightrr__list-feed .entry-meta .meta-com,.#{$pre}__article-col .entry-tags a,.entry-header .entry-meta .meta-com,#footer a:hover,#respond.#{$pre}__contact-form form span,.#{$pre}__widget ul a:hover,.widget_lightrr_popular_posts .entry-title a:hover,.widget_lightrr_popular_posts .popular_list .meta-cat a:hover,#footer .widget_lightrr_popular_posts .popular_list .meta-cat a,.widget_lightrr_popular_tabbed .entry-title a:hover,.widget_lightrr_popular_tabbed li.tabbed_list .meta-cat,.widget_lightrr_popular_tabbed .nav-tabs li.active a,.widget_lightrr_popular_tabbed .nav-tabs li.active a::before,#footer .widget_lightrr_popular_tabbed li.tabbed_list .meta-cat a,#footer .widget_lightrr_popular_tabbed .nav-tabs li.active a,.#{$pre}__load-nav .nav-load a:hover,.#{$pre}__load-nav .nav-load a:hover::after,.#{$pre}__site-navigation .nav-previous a:hover,.#{$pre}__site-navigation .nav-next a:hover,nav.#{$pre}__post-navigation a:hover,.#{$pre}__score-panel .#{$pre}__review-tag,.slide-mobmenu ul li a:hover,.slide-mobmenu ul li.current-menu-item a,.slide-mobmenu ul.sub-menu li a:hover' ),

		array('id' => 2, 'selector' => '.widget_quick-flickr-widget div img:hover,#footer .widget_quick-flickr-widget div img:hover,.widget_lightrr_authors ul li a:hover,.widget_tag_cloud ul li a:hover,.widget_tags_lightrr ul li a:hover,.widget_cats_lightrr ul li a:hover,ul.wp-tag-cloud li a:hover,#footer .widget_tag_cloud ul li a:hover,#footer .widget_tags_lightrr ul li a:hover,#footer .widget_cats_lightrr ul li a:hover' ),

		array('id' => 3, 'selector' => '#respond #reply-title,#footer .footer-tag p,.author-bio-card h4 span' ),

		array('id' => 4, 'selector' => '.#{$pre}__section-title span::after,.footer-container .#{$pre}__section-title span::after,#lightrr__top-bar,.#{$pre}__mod-left,.#{$pre}__container-grid .entry-title::after,.#{$pre}__container-featured .entry-title::after,#wp-calendar #today,.widget_lightrr_popular_posts .popular_list_top .meta-count,.widget_lightrr_popular_posts .popular_list_top .meta-com,.#{$pre}__info-share [class*="lightrr__icon-"]:hover,.#{$pre}__score-overlay .#{$pre}__label-score,.#{$pre}__score-overlay .#{$pre}__fill-score,.#{$pre}__score-panel .#{$pre}__score .#{$pre}__fill-score,.#{$pre}__single-page .#{$pre}__wrap-top-bar,.single .#{$pre}__wrap-top-bar, .#{$pre}__head-sticky .#{$pre}__wrap-top-bar.append,.owl-theme .owl-controls .owl-page.active span, .owl-theme .owl-controls.clickable .owl-page:hover span' ),

		array('id' => 5, 'selector' => '.#{$pre}__header-bar .sf-menu .current-menu-item a, .#{$pre}__header-bar .sf-menu .current-menu-parent a,.#{$pre}__header-bar .sf-menu li.#{$pre}__home-menu-current a, .#{$pre}__header-bar .sf-menu a:hover, .#{$pre}__header-bar .sf-menu .current-menu-parent ul li a, .#{$pre}__header-bar .sf-menu ul.sub-menu li a:hover, .#{$pre}__header-bar .sf-arrows > li:hover > .sf-with-ul, .#{$pre}__header-bar .sfHover > .sf-with-ul a, .#{$pre}__header-bar .sf-menu .current-menu-item a:hover, .#{$pre}__header-bar .sf-menu .current-menu-parent a:hover,.#{$pre}__navbar .sf-menu .current-menu-item a, .#{$pre}__navbar .sf-menu .current-menu-parent a,.#{$pre}__navbar .sf-menu li.#{$pre}__home-menu-current a, .#{$pre}__navbar .sf-menu a:hover, .#{$pre}__navbar .sf-menu .current-menu-parent ul li a, .#{$pre}__navbar .sf-menu ul.sub-menu li a:hover, .#{$pre}__navbar .sf-arrows > li:hover > .sf-with-ul, .#{$pre}__navbar .sfHover > .sf-with-ul a, .#{$pre}__navbar .sf-menu .current-menu-item a:hover, .#{$pre}__navbar .sf-menu .current-menu-parent a:hover' )
	);
	
	$props = array(
		1 => array( array('css_prop' => 'color', 'css_value' => '' . esc_attr($main_color) . '' ) ),
		2 => array( array('css_prop' => 'border-color', 'css_value' => '' . esc_attr($main_color) . '' ) ),
		3 => array( array('css_prop' => 'border-top-color', 'css_value' => '' . esc_attr($main_color) . '' ) ),
		4 => array( array('css_prop' => 'background-color', 'css_value' => '' . esc_attr($main_color) . '' ) ),
		5 => array( array('css_prop' => 'color', 'css_value' => '' . esc_attr($alt_color) . '' ) )
	);
	
	foreach ($query as $selector) {
		$properties = $props[$selector['id']];
		$rules = '';
		foreach ($properties as $element) {
			$rules.= "$element[css_prop]:$element[css_value];";
		}
		$output.= "$selector[selector]" . '{' . "$rules" . '}';
	}
	if (cs_get_option('custom_css', false)) {
		$output.= "\n".cs_get_option('custom_css');
	}
	if (!empty($output)) {
		wp_add_inline_style( 'lightrr__style', $output );
	}
}
add_action( 'wp_enqueue_scripts', 'lightrr_options_custom_styles' );